# Price Comparison Tables

A powerful, easy-to-use WordPress plugin for creating beautiful, responsive price comparison tables. Perfect for affiliate marketers, bloggers, and business sites.

## Features

- **Visual Table Builder**: Intuitive interface to add products and features
- **Responsive Design**: Automatically switches from table view on desktop to card view on mobile
- **Custom Post Type**: Tables are stored as their own post type for easy management
- **Multiple Themes**: Choose from Simple, Professional, or Modern themes
- **Customizable Colors**: Set accent and highlight colors to match your brand
- **Product Highlighting**: Mark best value options with badges and highlighting
- **Shortcode Support**: Embed tables anywhere with a simple shortcode
- **Clean Code**: Well-structured, WordPress best practices

## Installation

1. Upload the `price-comparison-tables` folder to the `/wp-content/plugins/` directory.
2. Activate the plugin through the 'Plugins' menu in WordPress.
3. Determine if you need to update settings (optional).

## Usage

1. Go to **Price Tables** > **Add New**.
2. Give your table a title.
3. Use the **Table Builder** to:
   - Add products (columns)
   - Add features (rows)
   - Enter your data
   - Set highlighting and colors
4. Publish the table.
5. Copy the shortcode (e.g., `[comparison_table id="123"]`) from the sidebar.
6. Paste the shortcode into any post or page.

## Shortcode Attributes

- `id` (required): The ID of the table to display.

Example: `[comparison_table id="10"]`

## Screenshots

*(Screenshots can be added here)*

## Changelog

### 1.0.0
- Initial release.
- Visual builder with drag-and-drop.
- Desktop and mobile responsive layouts.
